﻿using System;
using System.Linq.Expressions;

namespace WPF.PresentationLayer
{
    internal static class NameOf<T>
    {
        public static string Prop<TProp>(Expression<Func<T, TProp>> expression)
        {
            if (expression == null) throw new ArgumentNullException("expression");

            var body = expression.Body as MemberExpression;
            if (body == null) throw new ArgumentException("'expression' should be a member expression");
            // *** Fortify Justified Code ***
            // *** can't be null since it is checked earler. ReSharper doesn't see an issues either ***
            return body.Member.Name;

            // *** Fortify Justified Code *** 

        }
    }
}
